<?php
/**
 * The template to display Admin notices
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.64
 */

$pathfinder_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$pathfinder_skins_args = get_query_var( 'pathfinder_skins_notice_args' );
?>
<div class="pathfinder_admin_notice pathfinder_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$pathfinder_theme_img = pathfinder_get_file_url( 'screenshot.jpg' );
	if ( '' != $pathfinder_theme_img ) {
		?>
		<div class="pathfinder_notice_image"><img src="<?php echo esc_url( $pathfinder_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'pathfinder' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="pathfinder_notice_title">
		<?php esc_html_e( 'New skins available', 'pathfinder' ); ?>
	</h3>
	<?php

	// Description
	$pathfinder_total      = $pathfinder_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$pathfinder_skins_msg  = $pathfinder_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $pathfinder_total, 'pathfinder' ), $pathfinder_total ) . '</strong>'
							: '';
	$pathfinder_total      = $pathfinder_skins_args['free'];
	$pathfinder_skins_msg .= $pathfinder_total > 0
							? ( ! empty( $pathfinder_skins_msg ) ? ' ' . esc_html__( 'and', 'pathfinder' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $pathfinder_total, 'pathfinder' ), $pathfinder_total ) . '</strong>'
							: '';
	$pathfinder_total      = $pathfinder_skins_args['pay'];
	$pathfinder_skins_msg .= $pathfinder_skins_args['pay'] > 0
							? ( ! empty( $pathfinder_skins_msg ) ? ' ' . esc_html__( 'and', 'pathfinder' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $pathfinder_total, 'pathfinder' ), $pathfinder_total ) . '</strong>'
							: '';
	?>
	<div class="pathfinder_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'pathfinder' ), $pathfinder_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="pathfinder_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $pathfinder_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'pathfinder' );
			?>
		</a>
	</div>
</div>
