<?php
/**
 * The default template to displaying related posts
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.54
 */

$pathfinder_link        = get_permalink();
$pathfinder_post_format = get_post_format();
$pathfinder_post_format = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $pathfinder_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	pathfinder_show_post_featured(
		array(
			'thumb_size' => apply_filters( 'pathfinder_filter_related_thumb_size', pathfinder_get_thumb_size( (int) pathfinder_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
		)
	);
	?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $pathfinder_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( '- No title -', 'pathfinder' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			?>
			<span class="post_date"><a href="<?php echo esc_url( $pathfinder_link ); ?>"><?php echo wp_kses_data( pathfinder_get_date() ); ?></a></span>
			<?php
		}
		?>
	</div>
</div>
