<?php
/**
 * The template to display the widgets area in the header
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

// Header sidebar
$pathfinder_header_name    = pathfinder_get_theme_option( 'header_widgets' );
$pathfinder_header_present = ! pathfinder_is_off( $pathfinder_header_name ) && is_active_sidebar( $pathfinder_header_name );
if ( $pathfinder_header_present ) {
	pathfinder_storage_set( 'current_sidebar', 'header' );
	$pathfinder_header_wide = pathfinder_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $pathfinder_header_name ) ) {
		dynamic_sidebar( $pathfinder_header_name );
	}
	$pathfinder_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $pathfinder_widgets_output ) ) {
		$pathfinder_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $pathfinder_widgets_output );
		$pathfinder_need_columns   = strpos( $pathfinder_widgets_output, 'columns_wrap' ) === false;
		if ( $pathfinder_need_columns ) {
			$pathfinder_columns = max( 0, (int) pathfinder_get_theme_option( 'header_columns' ) );
			if ( 0 == $pathfinder_columns ) {
				$pathfinder_columns = min( 6, max( 1, pathfinder_tags_count( $pathfinder_widgets_output, 'aside' ) ) );
			}
			if ( $pathfinder_columns > 1 ) {
				$pathfinder_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $pathfinder_columns ) . ' widget', $pathfinder_widgets_output );
			} else {
				$pathfinder_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $pathfinder_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'pathfinder_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $pathfinder_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $pathfinder_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'pathfinder_action_before_sidebar', 'header' );
				pathfinder_show_layout( $pathfinder_widgets_output );
				do_action( 'pathfinder_action_after_sidebar', 'header' );
				if ( $pathfinder_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $pathfinder_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'pathfinder_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
