<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

// Page (category, tag, archive, author) title

if ( pathfinder_need_page_title() ) {
	pathfinder_sc_layouts_showed( 'title', true );
	pathfinder_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								pathfinder_show_post_meta(
									apply_filters(
										'pathfinder_filter_post_meta_args', array(
											'components' => join( ',', pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'counters' ) ) ),
											'seo'        => pathfinder_is_on( pathfinder_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$pathfinder_blog_title           = pathfinder_get_blog_title();
							$pathfinder_blog_title_text      = '';
							$pathfinder_blog_title_class     = '';
							$pathfinder_blog_title_link      = '';
							$pathfinder_blog_title_link_text = '';
							if ( is_array( $pathfinder_blog_title ) ) {
								$pathfinder_blog_title_text      = $pathfinder_blog_title['text'];
								$pathfinder_blog_title_class     = ! empty( $pathfinder_blog_title['class'] ) ? ' ' . $pathfinder_blog_title['class'] : '';
								$pathfinder_blog_title_link      = ! empty( $pathfinder_blog_title['link'] ) ? $pathfinder_blog_title['link'] : '';
								$pathfinder_blog_title_link_text = ! empty( $pathfinder_blog_title['link_text'] ) ? $pathfinder_blog_title['link_text'] : '';
							} else {
								$pathfinder_blog_title_text = $pathfinder_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $pathfinder_blog_title_class ); ?>">
								<?php
								$pathfinder_top_icon = pathfinder_get_term_image_small();
								if ( ! empty( $pathfinder_top_icon ) ) {
									$pathfinder_attr = pathfinder_getimagesize( $pathfinder_top_icon );
									?>
									<img src="<?php echo esc_url( $pathfinder_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'pathfinder' ); ?>"
										<?php
										if ( ! empty( $pathfinder_attr[3] ) ) {
											pathfinder_show_layout( $pathfinder_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $pathfinder_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $pathfinder_blog_title_link ) && ! empty( $pathfinder_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $pathfinder_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $pathfinder_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'pathfinder_action_breadcrumbs' );
						$pathfinder_breadcrumbs = ob_get_contents();
						ob_end_clean();
						pathfinder_show_layout( $pathfinder_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
