<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_args = get_query_var( 'pathfinder_logo_args' );

// Site logo
$pathfinder_logo_type   = isset( $pathfinder_args['type'] ) ? $pathfinder_args['type'] : '';
$pathfinder_logo_image  = pathfinder_get_logo_image( $pathfinder_logo_type );
$pathfinder_logo_text   = pathfinder_is_on( pathfinder_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$pathfinder_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $pathfinder_logo_image['logo'] ) || ! empty( $pathfinder_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $pathfinder_logo_image['logo'] ) ) {
			if ( empty( $pathfinder_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($pathfinder_logo_image['logo']) && (int) $pathfinder_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$pathfinder_attr = pathfinder_getimagesize( $pathfinder_logo_image['logo'] );
				echo '<img src="' . esc_url( $pathfinder_logo_image['logo'] ) . '"'
						. ( ! empty( $pathfinder_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $pathfinder_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $pathfinder_logo_text ) . '"'
						. ( ! empty( $pathfinder_attr[3] ) ? ' ' . wp_kses_data( $pathfinder_attr[3] ) : '' )
						. '>';
			}
		} else {
			pathfinder_show_layout( pathfinder_prepare_macros( $pathfinder_logo_text ), '<span class="logo_text">', '</span>' );
			pathfinder_show_layout( pathfinder_prepare_macros( $pathfinder_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
