<?php
/**
 * The template to display default site header
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_header_css   = '';
$pathfinder_header_image = get_header_image();
$pathfinder_header_video = pathfinder_get_header_video();
if ( ! empty( $pathfinder_header_image ) && pathfinder_trx_addons_featured_image_override( is_singular() || pathfinder_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$pathfinder_header_image = pathfinder_get_current_mode_image( $pathfinder_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $pathfinder_header_image ) || ! empty( $pathfinder_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $pathfinder_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $pathfinder_header_image ) {
		echo ' ' . esc_attr( pathfinder_add_inline_css_class( 'background-image: url(' . esc_url( $pathfinder_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( pathfinder_is_on( pathfinder_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight pathfinder-full-height';
	}
	$pathfinder_header_scheme = pathfinder_get_theme_option( 'header_scheme' );
	if ( ! empty( $pathfinder_header_scheme ) && ! pathfinder_is_inherit( $pathfinder_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $pathfinder_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $pathfinder_header_video ) ) {
		get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( pathfinder_is_on( pathfinder_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
