<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.06
 */

$pathfinder_header_css   = '';
$pathfinder_header_image = get_header_image();
$pathfinder_header_video = pathfinder_get_header_video();
if ( ! empty( $pathfinder_header_image ) && pathfinder_trx_addons_featured_image_override( is_singular() || pathfinder_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$pathfinder_header_image = pathfinder_get_current_mode_image( $pathfinder_header_image );
}

$pathfinder_header_id = pathfinder_get_custom_header_id();
$pathfinder_header_meta = get_post_meta( $pathfinder_header_id, 'trx_addons_options', true );
if ( ! empty( $pathfinder_header_meta['margin'] ) ) {
	pathfinder_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( pathfinder_prepare_css_value( $pathfinder_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $pathfinder_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $pathfinder_header_id ) ) ); ?>
				<?php
				echo ! empty( $pathfinder_header_image ) || ! empty( $pathfinder_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $pathfinder_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $pathfinder_header_image ) {
					echo ' ' . esc_attr( pathfinder_add_inline_css_class( 'background-image: url(' . esc_url( $pathfinder_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( pathfinder_is_on( pathfinder_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight pathfinder-full-height';
				}
				$pathfinder_header_scheme = pathfinder_get_theme_option( 'header_scheme' );
				if ( ! empty( $pathfinder_header_scheme ) && ! pathfinder_is_inherit( $pathfinder_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $pathfinder_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $pathfinder_header_video ) ) {
		get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'pathfinder_action_show_layout', $pathfinder_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
