<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.10
 */

// Footer sidebar
$pathfinder_footer_name    = pathfinder_get_theme_option( 'footer_widgets' );
$pathfinder_footer_present = ! pathfinder_is_off( $pathfinder_footer_name ) && is_active_sidebar( $pathfinder_footer_name );
if ( $pathfinder_footer_present ) {
	pathfinder_storage_set( 'current_sidebar', 'footer' );
	$pathfinder_footer_wide = pathfinder_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $pathfinder_footer_name ) ) {
		dynamic_sidebar( $pathfinder_footer_name );
	}
	$pathfinder_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $pathfinder_out ) ) {
		$pathfinder_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $pathfinder_out );
		$pathfinder_need_columns = true;   //or check: strpos($pathfinder_out, 'columns_wrap')===false;
		if ( $pathfinder_need_columns ) {
			$pathfinder_columns = max( 0, (int) pathfinder_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $pathfinder_columns ) {
				$pathfinder_columns = min( 4, max( 1, pathfinder_tags_count( $pathfinder_out, 'aside' ) ) );
			}
			if ( $pathfinder_columns > 1 ) {
				$pathfinder_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $pathfinder_columns ) . ' widget', $pathfinder_out );
			} else {
				$pathfinder_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $pathfinder_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'pathfinder_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $pathfinder_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $pathfinder_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'pathfinder_action_before_sidebar', 'footer' );
				pathfinder_show_layout( $pathfinder_out );
				do_action( 'pathfinder_action_after_sidebar', 'footer' );
				if ( $pathfinder_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $pathfinder_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'pathfinder_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
