<?php
/**
 * The template to display the site logo in the footer
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.10
 */

// Logo
if ( pathfinder_is_on( pathfinder_get_theme_option( 'logo_in_footer' ) ) ) {
	$pathfinder_logo_image = pathfinder_get_logo_image( 'footer' );
	$pathfinder_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $pathfinder_logo_image['logo'] ) || ! empty( $pathfinder_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $pathfinder_logo_image['logo'] ) ) {
					$pathfinder_attr = pathfinder_getimagesize( $pathfinder_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $pathfinder_logo_image['logo'] ) . '"'
								. ( ! empty( $pathfinder_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $pathfinder_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'pathfinder' ) . '"'
								. ( ! empty( $pathfinder_attr[3] ) ? ' ' . wp_kses_data( $pathfinder_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $pathfinder_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $pathfinder_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
