<?php
/**
 * The template to display default site footer
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.10
 */

$pathfinder_footer_id = pathfinder_get_custom_footer_id();
$pathfinder_footer_meta = get_post_meta( $pathfinder_footer_id, 'trx_addons_options', true );
if ( ! empty( $pathfinder_footer_meta['margin'] ) ) {
	pathfinder_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( pathfinder_prepare_css_value( $pathfinder_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $pathfinder_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $pathfinder_footer_id ) ) ); ?>
						<?php
						$pathfinder_footer_scheme = pathfinder_get_theme_option( 'footer_scheme' );
						if ( ! empty( $pathfinder_footer_scheme ) && ! pathfinder_is_inherit( $pathfinder_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $pathfinder_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'pathfinder_action_show_layout', $pathfinder_footer_id );
	?>
</footer><!-- /.footer_wrap -->
