<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$pathfinder_copyright_scheme = pathfinder_get_theme_option( 'copyright_scheme' );
if ( ! empty( $pathfinder_copyright_scheme ) && ! pathfinder_is_inherit( $pathfinder_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $pathfinder_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$pathfinder_copyright = pathfinder_get_theme_option( 'copyright' );
			if ( ! empty( $pathfinder_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$pathfinder_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $pathfinder_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$pathfinder_copyright = pathfinder_prepare_macros( $pathfinder_copyright );
				// Display copyright
				echo wp_kses( nl2br( $pathfinder_copyright ), 'pathfinder_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
