<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_template_args = get_query_var( 'pathfinder_template_args' );
if ( is_array( $pathfinder_template_args ) ) {
	$pathfinder_columns    = empty( $pathfinder_template_args['columns'] ) ? 2 : max( 1, $pathfinder_template_args['columns'] );
	$pathfinder_blog_style = array( $pathfinder_template_args['type'], $pathfinder_columns );
    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns, ! empty( $pathfinder_template_args['columns_tablet']) ? $pathfinder_template_args['columns_tablet'] : '', ! empty($pathfinder_template_args['columns_mobile']) ? $pathfinder_template_args['columns_mobile'] : '' );
} else {
	$pathfinder_blog_style = explode( '_', pathfinder_get_theme_option( 'blog_style' ) );
	$pathfinder_columns    = empty( $pathfinder_blog_style[1] ) ? 2 : max( 1, $pathfinder_blog_style[1] );
    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns );
}

$pathfinder_post_format = get_post_format();
$pathfinder_post_format = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );

?><div class="
<?php
if ( ! empty( $pathfinder_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( pathfinder_is_blog_style_use_masonry( $pathfinder_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $pathfinder_columns ) : esc_attr( $pathfinder_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $pathfinder_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $pathfinder_columns )
		. ( 'portfolio' != $pathfinder_blog_style[0] ? ' ' . esc_attr( $pathfinder_blog_style[0] )  . '_' . esc_attr( $pathfinder_columns ) : '' )
	);
	pathfinder_add_blog_animation( $pathfinder_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$pathfinder_hover   = ! empty( $pathfinder_template_args['hover'] ) && ! pathfinder_is_inherit( $pathfinder_template_args['hover'] )
								? $pathfinder_template_args['hover']
								: pathfinder_get_theme_option( 'image_hover' );

	if ( 'dots' == $pathfinder_hover ) {
		$pathfinder_post_link = empty( $pathfinder_template_args['no_links'] )
								? ( ! empty( $pathfinder_template_args['link'] )
									? $pathfinder_template_args['link']
									: get_permalink()
									)
								: '';
		$pathfinder_target    = ! empty( $pathfinder_post_link ) && false === strpos( $pathfinder_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$pathfinder_components = ! empty( $pathfinder_template_args['meta_parts'] )
							? ( is_array( $pathfinder_template_args['meta_parts'] )
								? $pathfinder_template_args['meta_parts']
								: explode( ',', $pathfinder_template_args['meta_parts'] )
								)
							: pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) );

	// Featured image
	pathfinder_show_post_featured( apply_filters( 'pathfinder_filter_args_featured',
        array(
			'hover'         => $pathfinder_hover,
			'no_links'      => ! empty( $pathfinder_template_args['no_links'] ),
			'thumb_size'    => ! empty( $pathfinder_template_args['thumb_size'] )
								? $pathfinder_template_args['thumb_size']
								: pathfinder_get_thumb_size(
									pathfinder_is_blog_style_use_masonry( $pathfinder_blog_style[0] )
										? (	strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false || $pathfinder_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false || $pathfinder_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => pathfinder_is_blog_style_use_masonry( $pathfinder_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $pathfinder_components,
			'class'         => 'dots' == $pathfinder_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $pathfinder_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $pathfinder_post_link )
												? '<a href="' . esc_url( $pathfinder_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $pathfinder_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $pathfinder_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $pathfinder_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!