<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_template_args = get_query_var( 'pathfinder_template_args' );
$pathfinder_columns = 1;
if ( is_array( $pathfinder_template_args ) ) {
	$pathfinder_columns    = empty( $pathfinder_template_args['columns'] ) ? 1 : max( 1, $pathfinder_template_args['columns'] );
	$pathfinder_blog_style = array( $pathfinder_template_args['type'], $pathfinder_columns );
	if ( ! empty( $pathfinder_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $pathfinder_columns > 1 ) {
	    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns, ! empty( $pathfinder_template_args['columns_tablet']) ? $pathfinder_template_args['columns_tablet'] : '', ! empty($pathfinder_template_args['columns_mobile']) ? $pathfinder_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $pathfinder_columns_class ); ?>">
		<?php
	}
}
$pathfinder_expanded    = ! pathfinder_sidebar_present() && pathfinder_get_theme_option( 'expand_content' ) == 'expand';
$pathfinder_post_format = get_post_format();
$pathfinder_post_format = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $pathfinder_post_format ) );
	pathfinder_add_blog_animation( $pathfinder_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$pathfinder_hover      = ! empty( $pathfinder_template_args['hover'] ) && ! pathfinder_is_inherit( $pathfinder_template_args['hover'] )
							? $pathfinder_template_args['hover']
							: pathfinder_get_theme_option( 'image_hover' );
	$pathfinder_components = ! empty( $pathfinder_template_args['meta_parts'] )
							? ( is_array( $pathfinder_template_args['meta_parts'] )
								? $pathfinder_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $pathfinder_template_args['meta_parts'] ) )
								)
							: pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) );
	pathfinder_show_post_featured( apply_filters( 'pathfinder_filter_args_featured',
		array(
			'no_links'   => ! empty( $pathfinder_template_args['no_links'] ),
			'hover'      => $pathfinder_hover,
			'meta_parts' => $pathfinder_components,
			'thumb_size' => ! empty( $pathfinder_template_args['thumb_size'] )
							? $pathfinder_template_args['thumb_size']
							: pathfinder_get_thumb_size( strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $pathfinder_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$pathfinder_template_args
	) );

	// Title and post meta
	$pathfinder_show_title = get_the_title() != '';
	$pathfinder_show_meta  = count( $pathfinder_components ) > 0 && ! in_array( $pathfinder_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $pathfinder_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'pathfinder_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'pathfinder_action_before_post_title' );
				if ( empty( $pathfinder_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'pathfinder_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'pathfinder_filter_show_blog_excerpt', empty( $pathfinder_template_args['hide_excerpt'] ) && pathfinder_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'pathfinder_filter_show_blog_meta', $pathfinder_show_meta, $pathfinder_components, 'excerpt' ) ) {
				if ( count( $pathfinder_components ) > 0 ) {
					do_action( 'pathfinder_action_before_post_meta' );
					pathfinder_show_post_meta(
						apply_filters(
							'pathfinder_filter_post_meta_args', array(
								'components' => join( ',', $pathfinder_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'pathfinder_action_after_post_meta' );
				}
			}

			if ( pathfinder_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'pathfinder_action_before_full_post_content' );
					the_content( '' );
					do_action( 'pathfinder_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'pathfinder' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'pathfinder' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				pathfinder_show_post_content( $pathfinder_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'pathfinder_filter_show_blog_readmore',  ! isset( $pathfinder_template_args['more_button'] ) || ! empty( $pathfinder_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $pathfinder_template_args['no_links'] ) ) {
					do_action( 'pathfinder_action_before_post_readmore' );
					if ( pathfinder_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						pathfinder_show_post_more_link( $pathfinder_template_args, '<p>', '</p>' );
					} else {
						pathfinder_show_post_comments_link( $pathfinder_template_args, '<p>', '</p>' );
					}
					do_action( 'pathfinder_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $pathfinder_template_args ) ) {
	if ( ! empty( $pathfinder_template_args['slider'] ) || $pathfinder_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
