<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.50
 */

$pathfinder_template_args = get_query_var( 'pathfinder_template_args' );
if ( is_array( $pathfinder_template_args ) ) {
	$pathfinder_columns    = empty( $pathfinder_template_args['columns'] ) ? 2 : max( 1, $pathfinder_template_args['columns'] );
	$pathfinder_blog_style = array( $pathfinder_template_args['type'], $pathfinder_columns );
} else {
	$pathfinder_blog_style = explode( '_', pathfinder_get_theme_option( 'blog_style' ) );
	$pathfinder_columns    = empty( $pathfinder_blog_style[1] ) ? 2 : max( 1, $pathfinder_blog_style[1] );
}
$pathfinder_blog_id       = pathfinder_get_custom_blog_id( join( '_', $pathfinder_blog_style ) );
$pathfinder_blog_style[0] = str_replace( 'blog-custom-', '', $pathfinder_blog_style[0] );
$pathfinder_expanded      = ! pathfinder_sidebar_present() && pathfinder_get_theme_option( 'expand_content' ) == 'expand';
$pathfinder_components    = ! empty( $pathfinder_template_args['meta_parts'] )
							? ( is_array( $pathfinder_template_args['meta_parts'] )
								? join( ',', $pathfinder_template_args['meta_parts'] )
								: $pathfinder_template_args['meta_parts']
								)
							: pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) );
$pathfinder_post_format   = get_post_format();
$pathfinder_post_format   = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );

$pathfinder_blog_meta     = pathfinder_get_custom_layout_meta( $pathfinder_blog_id );
$pathfinder_custom_style  = ! empty( $pathfinder_blog_meta['scripts_required'] ) ? $pathfinder_blog_meta['scripts_required'] : 'none';

if ( ! empty( $pathfinder_template_args['slider'] ) || $pathfinder_columns > 1 || ! pathfinder_is_off( $pathfinder_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $pathfinder_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( pathfinder_is_off( $pathfinder_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $pathfinder_custom_style ) ) . "-1_{$pathfinder_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $pathfinder_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $pathfinder_columns )
					. ' post_layout_' . esc_attr( $pathfinder_blog_style[0] )
					. ' post_layout_' . esc_attr( $pathfinder_blog_style[0] ) . '_' . esc_attr( $pathfinder_columns )
					. ( ! pathfinder_is_off( $pathfinder_custom_style )
						? ' post_layout_' . esc_attr( $pathfinder_custom_style )
							. ' post_layout_' . esc_attr( $pathfinder_custom_style ) . '_' . esc_attr( $pathfinder_columns )
						: ''
						)
		);
	pathfinder_add_blog_animation( $pathfinder_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'pathfinder_action_show_layout', $pathfinder_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $pathfinder_template_args['slider'] ) || $pathfinder_columns > 1 || ! pathfinder_is_off( $pathfinder_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
