<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_template_args = get_query_var( 'pathfinder_template_args' );

if ( is_array( $pathfinder_template_args ) ) {
	$pathfinder_columns    = empty( $pathfinder_template_args['columns'] ) ? 2 : max( 1, $pathfinder_template_args['columns'] );
	$pathfinder_blog_style = array( $pathfinder_template_args['type'], $pathfinder_columns );
    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns, ! empty( $pathfinder_template_args['columns_tablet']) ? $pathfinder_template_args['columns_tablet'] : '', ! empty($pathfinder_template_args['columns_mobile']) ? $pathfinder_template_args['columns_mobile'] : '' );
} else {
	$pathfinder_blog_style = explode( '_', pathfinder_get_theme_option( 'blog_style' ) );
	$pathfinder_columns    = empty( $pathfinder_blog_style[1] ) ? 2 : max( 1, $pathfinder_blog_style[1] );
    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns );
}
$pathfinder_expanded   = ! pathfinder_sidebar_present() && pathfinder_get_theme_option( 'expand_content' ) == 'expand';

$pathfinder_post_format = get_post_format();
$pathfinder_post_format = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );

?><div class="<?php
	if ( ! empty( $pathfinder_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( pathfinder_is_blog_style_use_masonry( $pathfinder_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $pathfinder_columns ) : esc_attr( $pathfinder_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $pathfinder_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $pathfinder_columns )
				. ' post_layout_' . esc_attr( $pathfinder_blog_style[0] )
				. ' post_layout_' . esc_attr( $pathfinder_blog_style[0] ) . '_' . esc_attr( $pathfinder_columns )
	);
	pathfinder_add_blog_animation( $pathfinder_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$pathfinder_hover      = ! empty( $pathfinder_template_args['hover'] ) && ! pathfinder_is_inherit( $pathfinder_template_args['hover'] )
							? $pathfinder_template_args['hover']
							: pathfinder_get_theme_option( 'image_hover' );

	$pathfinder_components = ! empty( $pathfinder_template_args['meta_parts'] )
							? ( is_array( $pathfinder_template_args['meta_parts'] )
								? $pathfinder_template_args['meta_parts']
								: explode( ',', $pathfinder_template_args['meta_parts'] )
								)
							: pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) );

	pathfinder_show_post_featured( apply_filters( 'pathfinder_filter_args_featured',
		array(
			'thumb_size' => ! empty( $pathfinder_template_args['thumb_size'] )
				? $pathfinder_template_args['thumb_size']
				: pathfinder_get_thumb_size(
				'classic' == $pathfinder_blog_style[0]
						? ( strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $pathfinder_columns > 2 ? 'big' : 'huge' )
								: ( $pathfinder_columns > 2
									? ( $pathfinder_expanded ? 'square' : 'square' )
									: ($pathfinder_columns > 1 ? 'square' : ( $pathfinder_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $pathfinder_columns > 2 ? 'masonry-big' : 'full' )
								: ($pathfinder_columns === 1 ? ( $pathfinder_expanded ? 'huge' : 'big' ) : ( $pathfinder_columns <= 2 && $pathfinder_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $pathfinder_hover,
			'meta_parts' => $pathfinder_components,
			'no_links'   => ! empty( $pathfinder_template_args['no_links'] ),
        ),
        'content-classic',
        $pathfinder_template_args
    ) );

	// Title and post meta
	$pathfinder_show_title = get_the_title() != '';
	$pathfinder_show_meta  = count( $pathfinder_components ) > 0 && ! in_array( $pathfinder_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $pathfinder_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'pathfinder_filter_show_blog_meta', $pathfinder_show_meta, $pathfinder_components, 'classic' ) ) {
				if ( count( $pathfinder_components ) > 0 ) {
					do_action( 'pathfinder_action_before_post_meta' );
					pathfinder_show_post_meta(
						apply_filters(
							'pathfinder_filter_post_meta_args', array(
							'components' => join( ',', $pathfinder_components ),
							'seo'        => false,
							'echo'       => true,
						), $pathfinder_blog_style[0], $pathfinder_columns
						)
					);
					do_action( 'pathfinder_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'pathfinder_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'pathfinder_action_before_post_title' );
				if ( empty( $pathfinder_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'pathfinder_action_after_post_title' );
			}

			if( !in_array( $pathfinder_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'pathfinder_filter_show_blog_readmore', ! $pathfinder_show_title || ! empty( $pathfinder_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $pathfinder_template_args['no_links'] ) ) {
						do_action( 'pathfinder_action_before_post_readmore' );
						pathfinder_show_post_more_link( $pathfinder_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'pathfinder_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $pathfinder_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('pathfinder_filter_show_blog_excerpt', empty($pathfinder_template_args['hide_excerpt']) && pathfinder_get_theme_option('excerpt_length') > 0, 'classic')) {
			pathfinder_show_post_content($pathfinder_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $pathfinder_template_args['more_button'] )) {
			if ( empty( $pathfinder_template_args['no_links'] ) ) {
				do_action( 'pathfinder_action_before_post_readmore' );
				pathfinder_show_post_more_link( $pathfinder_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'pathfinder_action_after_post_readmore' );
			}
		}
		$pathfinder_content = ob_get_contents();
		ob_end_clean();
		pathfinder_show_layout($pathfinder_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
