<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.71.0
 */

$pathfinder_template_args = get_query_var( 'pathfinder_template_args' );

$pathfinder_columns       = 1;

$pathfinder_expanded      = ! pathfinder_sidebar_present() && pathfinder_get_theme_option( 'expand_content' ) == 'expand';

$pathfinder_post_format   = get_post_format();
$pathfinder_post_format   = empty( $pathfinder_post_format ) ? 'standard' : str_replace( 'post-format-', '', $pathfinder_post_format );

if ( is_array( $pathfinder_template_args ) ) {
	$pathfinder_columns    = empty( $pathfinder_template_args['columns'] ) ? 1 : max( 1, $pathfinder_template_args['columns'] );
	$pathfinder_blog_style = array( $pathfinder_template_args['type'], $pathfinder_columns );
	if ( ! empty( $pathfinder_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $pathfinder_columns > 1 ) {
	    $pathfinder_columns_class = pathfinder_get_column_class( 1, $pathfinder_columns, ! empty( $pathfinder_template_args['columns_tablet']) ? $pathfinder_template_args['columns_tablet'] : '', ! empty($pathfinder_template_args['columns_mobile']) ? $pathfinder_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $pathfinder_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $pathfinder_post_format ) );
	pathfinder_add_blog_animation( $pathfinder_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$pathfinder_hover      = ! empty( $pathfinder_template_args['hover'] ) && ! pathfinder_is_inherit( $pathfinder_template_args['hover'] )
							? $pathfinder_template_args['hover']
							: pathfinder_get_theme_option( 'image_hover' );
	$pathfinder_components = ! empty( $pathfinder_template_args['meta_parts'] )
							? ( is_array( $pathfinder_template_args['meta_parts'] )
								? $pathfinder_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $pathfinder_template_args['meta_parts'] ) )
								)
							: pathfinder_array_get_keys_by_value( pathfinder_get_theme_option( 'meta_parts' ) );
	pathfinder_show_post_featured( apply_filters( 'pathfinder_filter_args_featured',
		array(
			'no_links'   => ! empty( $pathfinder_template_args['no_links'] ),
			'hover'      => $pathfinder_hover,
			'meta_parts' => $pathfinder_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $pathfinder_template_args['thumb_size'] )
								? $pathfinder_template_args['thumb_size']
								: pathfinder_get_thumb_size( 
								in_array( $pathfinder_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( pathfinder_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $pathfinder_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$pathfinder_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$pathfinder_show_title = get_the_title() != '';
		$pathfinder_show_meta  = count( $pathfinder_components ) > 0 && ! in_array( $pathfinder_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $pathfinder_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'pathfinder_filter_show_blog_categories', $pathfinder_show_meta && in_array( 'categories', $pathfinder_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'pathfinder_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						pathfinder_show_post_meta( apply_filters(
															'pathfinder_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $pathfinder_hover, 1
															)
											);
						?>
					</div>
					<?php
					$pathfinder_components = pathfinder_array_delete_by_value( $pathfinder_components, 'categories' );
					do_action( 'pathfinder_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'pathfinder_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'pathfinder_action_before_post_title' );
					if ( empty( $pathfinder_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'pathfinder_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $pathfinder_template_args['excerpt_length'] ) && ! in_array( $pathfinder_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$pathfinder_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'pathfinder_filter_show_blog_excerpt', empty( $pathfinder_template_args['hide_excerpt'] ) && pathfinder_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				pathfinder_show_post_content( $pathfinder_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'pathfinder_filter_show_blog_meta', $pathfinder_show_meta, $pathfinder_components, 'band' ) ) {
			if ( count( $pathfinder_components ) > 0 ) {
				do_action( 'pathfinder_action_before_post_meta' );
				pathfinder_show_post_meta(
					apply_filters(
						'pathfinder_filter_post_meta_args', array(
							'components' => join( ',', $pathfinder_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'pathfinder_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'pathfinder_filter_show_blog_readmore', ! $pathfinder_show_title || ! empty( $pathfinder_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $pathfinder_template_args['no_links'] ) ) {
				do_action( 'pathfinder_action_before_post_readmore' );
				pathfinder_show_post_more_link( $pathfinder_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'pathfinder_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $pathfinder_template_args ) ) {
	if ( ! empty( $pathfinder_template_args['slider'] ) || $pathfinder_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
