<?php
/**
 * The template to display Admin notices
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0.1
 */

$pathfinder_theme_slug = get_option( 'template' );
$pathfinder_theme_obj  = wp_get_theme( $pathfinder_theme_slug );
?>
<div class="pathfinder_admin_notice pathfinder_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$pathfinder_theme_img = pathfinder_get_file_url( 'screenshot.jpg' );
	if ( '' != $pathfinder_theme_img ) {
		?>
		<div class="pathfinder_notice_image"><img src="<?php echo esc_url( $pathfinder_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'pathfinder' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="pathfinder_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'pathfinder' ),
				$pathfinder_theme_obj->get( 'Name' ) . ( PATHFINDER_THEME_FREE ? ' ' . __( 'Free', 'pathfinder' ) : '' ),
				$pathfinder_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="pathfinder_notice_text">
		<p class="pathfinder_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $pathfinder_theme_obj->description ) );
			?>
		</p>
		<p class="pathfinder_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'pathfinder' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="pathfinder_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=pathfinder_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'pathfinder' );
			?>
		</a>
	</div>
</div>
