<?php
/* Twenty20 Image Before-After support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('pathfinder_twenty20_theme_setup9')) {
	add_action( 'after_setup_theme', 'pathfinder_twenty20_theme_setup9', 9 );
	function pathfinder_twenty20_theme_setup9() {
		if (is_admin()) {
			add_filter( 'pathfinder_filter_tgmpa_required_plugins',		'pathfinder_twenty20_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'pathfinder_twenty20_tgmpa_required_plugins' ) ) {
	function pathfinder_twenty20_tgmpa_required_plugins($list=array()) {
		if (pathfinder_storage_isset('required_plugins', 'twenty20') && pathfinder_storage_get_array( 'required_plugins', 'twenty20', 'install' ) !== false) {
			$list[] = array(
				'name' 		=> pathfinder_storage_get_array('required_plugins', 'twenty20', 'title'),
				'slug' 		=> 'twenty20',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'pathfinder_exists_twenty20' ) ) {
	function pathfinder_exists_twenty20() {
		return function_exists('twenty20_dir_init');
	}
}

?>