<?php

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'pathfinder_advanced_popups_theme_setup9' ) ) {
    add_action( 'after_setup_theme', 'pathfinder_advanced_popups_theme_setup9', 9 );
    function pathfinder_advanced_popups_theme_setup9() {
        if ( is_admin() ) {
            add_filter( 'pathfinder_filter_tgmpa_required_plugins', 'pathfinder_advanced_popups_tgmpa_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( ! function_exists( 'pathfinder_advanced_popups_tgmpa_required_plugins' ) ) {    
    function pathfinder_advanced_popups_tgmpa_required_plugins( $list = array() ) {
        if ( pathfinder_storage_isset( 'required_plugins', 'advanced-popups' ) && pathfinder_storage_get_array( 'required_plugins', 'advanced-popups', 'install' ) !== false ) {
            $list[] = array(
                'name'     => pathfinder_storage_get_array( 'required_plugins', 'advanced-popups', 'title' ),
                'slug'     => 'advanced-popups',
                'required' => false,
            );
        }
        return $list;
    }
}

// Check if plugin installed and activated
if ( ! function_exists( 'pathfinder_exists_advanced_popups' ) ) {
    function pathfinder_exists_advanced_popups() {
        return function_exists('adp_init');
    }
}
