<?php
/**
 * The template to display single post
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

// Full post loading
$full_post_loading          = pathfinder_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = pathfinder_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = pathfinder_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$pathfinder_related_position   = pathfinder_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$pathfinder_posts_navigation   = pathfinder_get_theme_option( 'posts_navigation' );
$pathfinder_prev_post          = false;
$pathfinder_prev_post_same_cat = pathfinder_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( pathfinder_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	pathfinder_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'pathfinder_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $pathfinder_posts_navigation ) {
		$pathfinder_prev_post = get_previous_post( $pathfinder_prev_post_same_cat );  // Get post from same category
		if ( ! $pathfinder_prev_post && $pathfinder_prev_post_same_cat ) {
			$pathfinder_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $pathfinder_prev_post ) {
			$pathfinder_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $pathfinder_prev_post ) ) {
		pathfinder_sc_layouts_showed( 'featured', false );
		pathfinder_sc_layouts_showed( 'title', false );
		pathfinder_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $pathfinder_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/content', 'single-' . pathfinder_get_theme_option( 'single_style' ) ), 'single-' . pathfinder_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $pathfinder_related_position, 'inside' ) === 0 ) {
		$pathfinder_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'pathfinder_action_related_posts' );
		$pathfinder_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $pathfinder_related_content ) ) {
			$pathfinder_related_position_inside = max( 0, min( 9, pathfinder_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $pathfinder_related_position_inside ) {
				$pathfinder_related_position_inside = mt_rand( 1, 9 );
			}

			$pathfinder_p_number         = 0;
			$pathfinder_related_inserted = false;
			$pathfinder_in_block         = false;
			$pathfinder_content_start    = strpos( $pathfinder_content, '<div class="post_content' );
			$pathfinder_content_end      = strrpos( $pathfinder_content, '</div>' );

			for ( $i = max( 0, $pathfinder_content_start ); $i < min( strlen( $pathfinder_content ) - 3, $pathfinder_content_end ); $i++ ) {
				if ( $pathfinder_content[ $i ] != '<' ) {
					continue;
				}
				if ( $pathfinder_in_block ) {
					if ( strtolower( substr( $pathfinder_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$pathfinder_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $pathfinder_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $pathfinder_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$pathfinder_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $pathfinder_content[ $i + 1 ] && in_array( $pathfinder_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$pathfinder_p_number++;
					if ( $pathfinder_related_position_inside == $pathfinder_p_number ) {
						$pathfinder_related_inserted = true;
						$pathfinder_content = ( $i > 0 ? substr( $pathfinder_content, 0, $i ) : '' )
											. $pathfinder_related_content
											. substr( $pathfinder_content, $i );
					}
				}
			}
			if ( ! $pathfinder_related_inserted ) {
				if ( $pathfinder_content_end > 0 ) {
					$pathfinder_content = substr( $pathfinder_content, 0, $pathfinder_content_end ) . $pathfinder_related_content . substr( $pathfinder_content, $pathfinder_content_end );
				} else {
					$pathfinder_content .= $pathfinder_related_content;
				}
			}
		}

		pathfinder_show_layout( $pathfinder_content );
	}

	// Comments
	do_action( 'pathfinder_action_before_comments' );
	comments_template();
	do_action( 'pathfinder_action_after_comments' );

	// Related posts
	if ( 'below_content' == $pathfinder_related_position
		&& ( 'scroll' != $pathfinder_posts_navigation || pathfinder_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || pathfinder_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'pathfinder_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $pathfinder_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $pathfinder_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $pathfinder_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $pathfinder_prev_post ) ); ?>"
			<?php do_action( 'pathfinder_action_nav_links_single_scroll_data', $pathfinder_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
