<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

if ( pathfinder_sidebar_present() ) {
	
	$pathfinder_sidebar_type = pathfinder_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $pathfinder_sidebar_type && ! pathfinder_is_layouts_available() ) {
		$pathfinder_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $pathfinder_sidebar_type ) {
		// Default sidebar with widgets
		$pathfinder_sidebar_name = pathfinder_get_theme_option( 'sidebar_widgets' );
		pathfinder_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $pathfinder_sidebar_name ) ) {
			dynamic_sidebar( $pathfinder_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$pathfinder_sidebar_id = pathfinder_get_custom_sidebar_id();
		do_action( 'pathfinder_action_show_layout', $pathfinder_sidebar_id );
	}
	$pathfinder_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $pathfinder_out ) ) {
		$pathfinder_sidebar_position    = pathfinder_get_theme_option( 'sidebar_position' );
		$pathfinder_sidebar_position_ss = pathfinder_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $pathfinder_sidebar_position );
			echo ' sidebar_' . esc_attr( $pathfinder_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $pathfinder_sidebar_type );

			$pathfinder_sidebar_scheme = apply_filters( 'pathfinder_filter_sidebar_scheme', pathfinder_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $pathfinder_sidebar_scheme ) && ! pathfinder_is_inherit( $pathfinder_sidebar_scheme ) && 'custom' != $pathfinder_sidebar_type ) {
				echo ' scheme_' . esc_attr( $pathfinder_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="pathfinder_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'pathfinder_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $pathfinder_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$pathfinder_title = apply_filters( 'pathfinder_filter_sidebar_control_title', 'float' == $pathfinder_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'pathfinder' ) : '' );
				$pathfinder_text  = apply_filters( 'pathfinder_filter_sidebar_control_text', 'above' == $pathfinder_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'pathfinder' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $pathfinder_title ); ?>"><?php echo esc_html( $pathfinder_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'pathfinder_action_before_sidebar', 'sidebar' );
				pathfinder_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $pathfinder_out ) );
				do_action( 'pathfinder_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'pathfinder_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
