<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'pathfinder_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'pathfinder_cf7_theme_setup9', 9 );
	function pathfinder_cf7_theme_setup9() {
		if ( pathfinder_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'pathfinder_cf7_frontend_scripts', 1100 );
			add_action( 'trx_addons_action_load_scripts_front_cf7', 'pathfinder_cf7_frontend_scripts', 10, 1 );
			add_filter( 'pathfinder_filter_merge_styles', 'pathfinder_cf7_merge_styles' );
			add_filter( 'pathfinder_filter_merge_scripts', 'pathfinder_cf7_merge_scripts' );
		}
		if ( is_admin() ) {
			add_filter( 'pathfinder_filter_tgmpa_required_plugins', 'pathfinder_cf7_tgmpa_required_plugins' );
			add_filter( 'pathfinder_filter_theme_plugins', 'pathfinder_cf7_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'pathfinder_cf7_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('pathfinder_filter_tgmpa_required_plugins',	'pathfinder_cf7_tgmpa_required_plugins');
	function pathfinder_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( pathfinder_storage_isset( 'required_plugins', 'contact-form-7' ) && pathfinder_storage_get_array( 'required_plugins', 'contact-form-7', 'install' ) !== false ) {
			// CF7 plugin
			$list[] = array(
				'name'     => pathfinder_storage_get_array( 'required_plugins', 'contact-form-7', 'title' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'pathfinder_cf7_theme_plugins' ) ) {
	//Handler of the add_filter( 'pathfinder_filter_theme_plugins', 'pathfinder_cf7_theme_plugins' );
	function pathfinder_cf7_theme_plugins( $list = array() ) {
		return pathfinder_add_group_and_logo_to_slave( $list, 'contact-form-7', 'contact-form-7-' );
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'pathfinder_exists_cf7' ) ) {
	function pathfinder_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'pathfinder_cf7_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'pathfinder_cf7_frontend_scripts', 1100 );
	//Handler of the add_action( 'trx_addons_action_load_scripts_front_cf7', 'pathfinder_cf7_frontend_scripts', 10, 1 );
	function pathfinder_cf7_frontend_scripts( $force = false ) {
		static $loaded = false;
		if ( ! $loaded && (
			current_action() == 'wp_enqueue_scripts' && pathfinder_need_frontend_scripts( 'cf7' )
			||
			current_action() != 'wp_enqueue_scripts' && $force === true
			)
		) {
			$loaded = true;
			$pathfinder_url = pathfinder_get_file_url( 'plugins/contact-form-7/contact-form-7.css' );
			if ( '' != $pathfinder_url ) {
				wp_enqueue_style( 'pathfinder-contact-form-7', $pathfinder_url, array(), null );
			}
			$pathfinder_url = pathfinder_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
			if ( '' != $pathfinder_url ) {
				wp_enqueue_script( 'pathfinder-contact-form-7', $pathfinder_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'pathfinder_cf7_merge_styles' ) ) {
	//Handler of the add_filter('pathfinder_filter_merge_styles', 'pathfinder_cf7_merge_styles');
	function pathfinder_cf7_merge_styles( $list ) {
		$list[ 'plugins/contact-form-7/contact-form-7.css' ] = false;
		return $list;
	}
}

// Merge custom scripts
if ( ! function_exists( 'pathfinder_cf7_merge_scripts' ) ) {
	//Handler of the add_filter('pathfinder_filter_merge_scripts', 'pathfinder_cf7_merge_scripts');
	function pathfinder_cf7_merge_scripts( $list ) {
		$list[ 'plugins/contact-form-7/contact-form-7.js' ] = false;
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( pathfinder_exists_cf7() ) {
	require_once pathfinder_get_file_dir( 'plugins/contact-form-7/contact-form-7-style.php' );
}
