<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

$pathfinder_template = apply_filters( 'pathfinder_filter_get_template_part', pathfinder_blog_archive_get_template() );

if ( ! empty( $pathfinder_template ) && 'index' != $pathfinder_template ) {

	get_template_part( $pathfinder_template );

} else {

	pathfinder_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$pathfinder_stickies   = is_home()
								|| ( in_array( pathfinder_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) pathfinder_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$pathfinder_post_type  = pathfinder_get_theme_option( 'post_type' );
		$pathfinder_args       = array(
								'blog_style'     => pathfinder_get_theme_option( 'blog_style' ),
								'post_type'      => $pathfinder_post_type,
								'taxonomy'       => pathfinder_get_post_type_taxonomy( $pathfinder_post_type ),
								'parent_cat'     => pathfinder_get_theme_option( 'parent_cat' ),
								'posts_per_page' => pathfinder_get_theme_option( 'posts_per_page' ),
								'sticky'         => pathfinder_get_theme_option( 'sticky_style' ) == 'columns'
															&& is_array( $pathfinder_stickies )
															&& count( $pathfinder_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		pathfinder_blog_archive_start();

		do_action( 'pathfinder_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'pathfinder_action_before_page_author' );
			get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'pathfinder_action_after_page_author' );
		}

		if ( pathfinder_get_theme_option( 'show_filters' ) ) {
			do_action( 'pathfinder_action_before_page_filters' );
			pathfinder_show_filters( $pathfinder_args );
			do_action( 'pathfinder_action_after_page_filters' );
		} else {
			do_action( 'pathfinder_action_before_page_posts' );
			pathfinder_show_posts( array_merge( $pathfinder_args, array( 'cat' => $pathfinder_args['parent_cat'] ) ) );
			do_action( 'pathfinder_action_after_page_posts' );
		}

		do_action( 'pathfinder_action_blog_archive_end' );

		pathfinder_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
