<?php
/**
 * The Header: Logo and main menu
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( pathfinder_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'pathfinder_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'pathfinder_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('pathfinder_action_body_wrap_attributes'); ?>>

		<?php do_action( 'pathfinder_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'pathfinder_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('pathfinder_action_page_wrap_attributes'); ?>>

			<?php do_action( 'pathfinder_action_page_wrap_start' ); ?>

			<?php
			$pathfinder_full_post_loading = ( pathfinder_is_singular( 'post' ) || pathfinder_is_singular( 'attachment' ) ) && pathfinder_get_value_gp( 'action' ) == 'full_post_loading';
			$pathfinder_prev_post_loading = ( pathfinder_is_singular( 'post' ) || pathfinder_is_singular( 'attachment' ) ) && pathfinder_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $pathfinder_full_post_loading && ! $pathfinder_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="pathfinder_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to content", 'pathfinder' ); ?></a>
				<?php if ( pathfinder_sidebar_present() ) { ?>
				<a class="pathfinder_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to sidebar", 'pathfinder' ); ?></a>
				<?php } ?>
				<a class="pathfinder_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="1"><?php esc_html_e( "Skip to footer", 'pathfinder' ); ?></a>

				<?php
				do_action( 'pathfinder_action_before_header' );

				// Header
				$pathfinder_header_type = pathfinder_get_theme_option( 'header_type' );
				if ( 'custom' == $pathfinder_header_type && ! pathfinder_is_layouts_available() ) {
					$pathfinder_header_type = 'default';
				}
				get_template_part( apply_filters( 'pathfinder_filter_get_template_part', "templates/header-" . sanitize_file_name( $pathfinder_header_type ) ) );

				// Side menu
				if ( in_array( pathfinder_get_theme_option( 'menu_side' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				get_template_part( apply_filters( 'pathfinder_filter_get_template_part', 'templates/header-navi-mobile' ) );

				do_action( 'pathfinder_action_after_header' );

			}
			?>

			<?php do_action( 'pathfinder_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( pathfinder_is_off( pathfinder_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $pathfinder_header_type ) ) {
						$pathfinder_header_type = pathfinder_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $pathfinder_header_type && pathfinder_is_layouts_available() ) {
						$pathfinder_header_id = pathfinder_get_custom_header_id();
						if ( $pathfinder_header_id > 0 ) {
							$pathfinder_header_meta = pathfinder_get_custom_layout_meta( $pathfinder_header_id );
							if ( ! empty( $pathfinder_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$pathfinder_footer_type = pathfinder_get_theme_option( 'footer_type' );
					if ( 'custom' == $pathfinder_footer_type && pathfinder_is_layouts_available() ) {
						$pathfinder_footer_id = pathfinder_get_custom_footer_id();
						if ( $pathfinder_footer_id ) {
							$pathfinder_footer_meta = pathfinder_get_custom_layout_meta( $pathfinder_footer_id );
							if ( ! empty( $pathfinder_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'pathfinder_action_page_content_wrap_class', $pathfinder_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'pathfinder_filter_is_prev_post_loading', $pathfinder_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( pathfinder_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'pathfinder_action_page_content_wrap_data', $pathfinder_prev_post_loading );
			?>>
				<?php
				do_action( 'pathfinder_action_page_content_wrap', $pathfinder_full_post_loading || $pathfinder_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'pathfinder_filter_single_post_header', pathfinder_is_singular( 'post' ) || pathfinder_is_singular( 'attachment' ) ) ) {
					if ( $pathfinder_prev_post_loading ) {
						if ( pathfinder_get_theme_option( 'posts_navigation_scroll_which_block' ) != 'article' ) {
							do_action( 'pathfinder_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$pathfinder_path = apply_filters( 'pathfinder_filter_get_template_part', 'templates/single-styles/' . pathfinder_get_theme_option( 'single_style' ) );
					if ( pathfinder_get_file_dir( $pathfinder_path . '.php' ) != '' ) {
						get_template_part( $pathfinder_path );
					}
				}

				// Widgets area above page
				$pathfinder_body_style   = pathfinder_get_theme_option( 'body_style' );
				$pathfinder_widgets_name = pathfinder_get_theme_option( 'widgets_above_page' );
				$pathfinder_show_widgets = ! pathfinder_is_off( $pathfinder_widgets_name ) && is_active_sidebar( $pathfinder_widgets_name );
				if ( $pathfinder_show_widgets ) {
					if ( 'fullscreen' != $pathfinder_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					pathfinder_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $pathfinder_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'pathfinder_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $pathfinder_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'pathfinder_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'pathfinder_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="pathfinder_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( pathfinder_is_singular( 'post' ) || pathfinder_is_singular( 'attachment' ) )
							&& $pathfinder_prev_post_loading 
							&& pathfinder_get_theme_option( 'posts_navigation_scroll_which_block' ) == 'article'
						) {
							do_action( 'pathfinder_action_between_posts' );
						}

						// Widgets area above content
						pathfinder_create_widgets_area( 'widgets_above_content' );

						do_action( 'pathfinder_action_page_content_start_text' );
