<?php
$pathfinder_woocommerce_sc = pathfinder_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $pathfinder_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$pathfinder_scheme = pathfinder_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $pathfinder_scheme ) && ! pathfinder_is_inherit( $pathfinder_scheme ) ) {
			echo ' scheme_' . esc_attr( $pathfinder_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( pathfinder_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( pathfinder_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$pathfinder_css      = '';
			$pathfinder_bg_image = pathfinder_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $pathfinder_bg_image ) ) {
				$pathfinder_css .= 'background-image: url(' . esc_url( pathfinder_get_attachment_url( $pathfinder_bg_image ) ) . ');';
			}
			if ( ! empty( $pathfinder_css ) ) {
				echo ' style="' . esc_attr( $pathfinder_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$pathfinder_anchor_icon = pathfinder_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$pathfinder_anchor_text = pathfinder_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $pathfinder_anchor_icon ) || ! empty( $pathfinder_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $pathfinder_anchor_icon ) ? ' icon="' . esc_attr( $pathfinder_anchor_icon ) . '"' : '' )
											. ( ! empty( $pathfinder_anchor_text ) ? ' title="' . esc_attr( $pathfinder_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( pathfinder_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' pathfinder-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$pathfinder_css      = '';
				$pathfinder_bg_mask  = pathfinder_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$pathfinder_bg_color_type = pathfinder_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $pathfinder_bg_color_type ) {
					$pathfinder_bg_color = pathfinder_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $pathfinder_bg_color_type ) {
					$pathfinder_bg_color = pathfinder_get_scheme_color( 'bg_color', $pathfinder_scheme );
				} else {
					$pathfinder_bg_color = '';
				}
				if ( ! empty( $pathfinder_bg_color ) && $pathfinder_bg_mask > 0 ) {
					$pathfinder_css .= 'background-color: ' . esc_attr(
						1 == $pathfinder_bg_mask ? $pathfinder_bg_color : pathfinder_hex2rgba( $pathfinder_bg_color, $pathfinder_bg_mask )
					) . ';';
				}
				if ( ! empty( $pathfinder_css ) ) {
					echo ' style="' . esc_attr( $pathfinder_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$pathfinder_caption     = pathfinder_get_theme_option( 'front_page_woocommerce_caption' );
				$pathfinder_description = pathfinder_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $pathfinder_caption ) || ! empty( $pathfinder_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $pathfinder_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $pathfinder_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $pathfinder_caption, 'pathfinder_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $pathfinder_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $pathfinder_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $pathfinder_description ), 'pathfinder_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $pathfinder_woocommerce_sc ) {
						$pathfinder_woocommerce_sc_ids      = pathfinder_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$pathfinder_woocommerce_sc_per_page = count( explode( ',', $pathfinder_woocommerce_sc_ids ) );
					} else {
						$pathfinder_woocommerce_sc_per_page = max( 1, (int) pathfinder_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$pathfinder_woocommerce_sc_columns = max( 1, min( $pathfinder_woocommerce_sc_per_page, (int) pathfinder_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$pathfinder_woocommerce_sc}"
										. ( 'products' == $pathfinder_woocommerce_sc
												? ' ids="' . esc_attr( $pathfinder_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $pathfinder_woocommerce_sc
												? ' category="' . esc_attr( pathfinder_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $pathfinder_woocommerce_sc
												? ' orderby="' . esc_attr( pathfinder_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( pathfinder_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $pathfinder_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $pathfinder_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
