<?php
$pathfinder_slider_sc = pathfinder_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $pathfinder_slider_sc ) && strpos( $pathfinder_slider_sc, '[' ) !== false && strpos( $pathfinder_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( pathfinder_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$pathfinder_anchor_icon = pathfinder_get_theme_option( 'front_page_title_anchor_icon' );
		$pathfinder_anchor_text = pathfinder_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $pathfinder_anchor_icon ) || ! empty( $pathfinder_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $pathfinder_anchor_icon ) ? ' icon="' . esc_attr( $pathfinder_anchor_icon ) . '"' : '' )
									. ( ! empty( $pathfinder_anchor_text ) ? ' title="' . esc_attr( $pathfinder_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $pathfinder_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$pathfinder_scheme = pathfinder_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $pathfinder_scheme ) && ! pathfinder_is_inherit( $pathfinder_scheme ) ) {
			echo ' scheme_' . esc_attr( $pathfinder_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( pathfinder_get_theme_option( 'front_page_title_paddings' ) );
		if ( pathfinder_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$pathfinder_css      = '';
		$pathfinder_bg_image = pathfinder_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $pathfinder_bg_image ) ) {
			$pathfinder_css .= 'background-image: url(' . esc_url( pathfinder_get_attachment_url( $pathfinder_bg_image ) ) . ');';
		}
		if ( ! empty( $pathfinder_css ) ) {
			echo ' style="' . esc_attr( $pathfinder_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$pathfinder_anchor_icon = pathfinder_get_theme_option( 'front_page_title_anchor_icon' );
		$pathfinder_anchor_text = pathfinder_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $pathfinder_anchor_icon ) || ! empty( $pathfinder_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $pathfinder_anchor_icon ) ? ' icon="' . esc_attr( $pathfinder_anchor_icon ) . '"' : '' )
									. ( ! empty( $pathfinder_anchor_text ) ? ' title="' . esc_attr( $pathfinder_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( pathfinder_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' pathfinder-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$pathfinder_css      = '';
			$pathfinder_bg_mask  = pathfinder_get_theme_option( 'front_page_title_bg_mask' );
			$pathfinder_bg_color_type = pathfinder_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $pathfinder_bg_color_type ) {
				$pathfinder_bg_color = pathfinder_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $pathfinder_bg_color_type ) {
				$pathfinder_bg_color = pathfinder_get_scheme_color( 'bg_color', $pathfinder_scheme );
			} else {
				$pathfinder_bg_color = '';
			}
			if ( ! empty( $pathfinder_bg_color ) && $pathfinder_bg_mask > 0 ) {
				$pathfinder_css .= 'background-color: ' . esc_attr(
					1 == $pathfinder_bg_mask ? $pathfinder_bg_color : pathfinder_hex2rgba( $pathfinder_bg_color, $pathfinder_bg_mask )
				) . ';';
			}
			if ( ! empty( $pathfinder_css ) ) {
				echo ' style="' . esc_attr( $pathfinder_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$pathfinder_caption = pathfinder_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $pathfinder_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $pathfinder_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $pathfinder_caption, 'pathfinder_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$pathfinder_description = pathfinder_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $pathfinder_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $pathfinder_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $pathfinder_description ), 'pathfinder_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( pathfinder_get_theme_option( 'front_page_title_button1_link' ) != '' || pathfinder_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						pathfinder_show_layout( pathfinder_customizer_partial_refresh_front_page_title_button1_link() );
						pathfinder_show_layout( pathfinder_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
