<div class="front_page_section front_page_section_contacts<?php
	$pathfinder_scheme = pathfinder_get_theme_option( 'front_page_contacts_scheme' );
	if ( ! empty( $pathfinder_scheme ) && ! pathfinder_is_inherit( $pathfinder_scheme ) ) {
		echo ' scheme_' . esc_attr( $pathfinder_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( pathfinder_get_theme_option( 'front_page_contacts_paddings' ) );
	if ( pathfinder_get_theme_option( 'front_page_contacts_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$pathfinder_css      = '';
		$pathfinder_bg_image = pathfinder_get_theme_option( 'front_page_contacts_bg_image' );
		if ( ! empty( $pathfinder_bg_image ) ) {
			$pathfinder_css .= 'background-image: url(' . esc_url( pathfinder_get_attachment_url( $pathfinder_bg_image ) ) . ');';
		}
		if ( ! empty( $pathfinder_css ) ) {
			echo ' style="' . esc_attr( $pathfinder_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$pathfinder_anchor_icon = pathfinder_get_theme_option( 'front_page_contacts_anchor_icon' );
	$pathfinder_anchor_text = pathfinder_get_theme_option( 'front_page_contacts_anchor_text' );
if ( ( ! empty( $pathfinder_anchor_icon ) || ! empty( $pathfinder_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_contacts"'
									. ( ! empty( $pathfinder_anchor_icon ) ? ' icon="' . esc_attr( $pathfinder_anchor_icon ) . '"' : '' )
									. ( ! empty( $pathfinder_anchor_text ) ? ' title="' . esc_attr( $pathfinder_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_contacts_inner
	<?php
	if ( pathfinder_get_theme_option( 'front_page_contacts_fullheight' ) ) {
		echo ' pathfinder-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$pathfinder_css      = '';
			$pathfinder_bg_mask  = pathfinder_get_theme_option( 'front_page_contacts_bg_mask' );
			$pathfinder_bg_color_type = pathfinder_get_theme_option( 'front_page_contacts_bg_color_type' );
			if ( 'custom' == $pathfinder_bg_color_type ) {
				$pathfinder_bg_color = pathfinder_get_theme_option( 'front_page_contacts_bg_color' );
			} elseif ( 'scheme_bg_color' == $pathfinder_bg_color_type ) {
				$pathfinder_bg_color = pathfinder_get_scheme_color( 'bg_color', $pathfinder_scheme );
			} else {
				$pathfinder_bg_color = '';
			}
			if ( ! empty( $pathfinder_bg_color ) && $pathfinder_bg_mask > 0 ) {
				$pathfinder_css .= 'background-color: ' . esc_attr(
					1 == $pathfinder_bg_mask ? $pathfinder_bg_color : pathfinder_hex2rgba( $pathfinder_bg_color, $pathfinder_bg_mask )
				) . ';';
			}
			if ( ! empty( $pathfinder_css ) ) {
				echo ' style="' . esc_attr( $pathfinder_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_contacts_content_wrap content_wrap">
			<?php

			// Title and description
			$pathfinder_caption     = pathfinder_get_theme_option( 'front_page_contacts_caption' );
			$pathfinder_description = pathfinder_get_theme_option( 'front_page_contacts_description' );
			if ( ! empty( $pathfinder_caption ) || ! empty( $pathfinder_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				// Caption
				if ( ! empty( $pathfinder_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_contacts_caption front_page_block_<?php echo ! empty( $pathfinder_caption ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( $pathfinder_caption, 'pathfinder_kses_content' );
					?>
					</h2>
					<?php
				}

				// Description
				if ( ! empty( $pathfinder_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_contacts_description front_page_block_<?php echo ! empty( $pathfinder_description ) ? 'filled' : 'empty'; ?>">
					<?php
						echo wp_kses( wpautop( $pathfinder_description ), 'pathfinder_kses_content' );
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$pathfinder_content = pathfinder_get_theme_option( 'front_page_contacts_content' );
			$pathfinder_layout  = pathfinder_get_theme_option( 'front_page_contacts_layout' );
			if ( 'columns' == $pathfinder_layout && ( ! empty( $pathfinder_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_columns front_page_section_contacts_columns columns_wrap">
					<div class="column-1_3">
				<?php
			}

			if ( ( ! empty( $pathfinder_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				<div class="front_page_section_content front_page_section_contacts_content front_page_block_<?php echo ! empty( $pathfinder_content ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $pathfinder_content, 'pathfinder_kses_content' );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $pathfinder_layout && ( ! empty( $pathfinder_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div><div class="column-2_3">
				<?php
			}

			// Shortcode output
			$pathfinder_sc = pathfinder_get_theme_option( 'front_page_contacts_shortcode' );
			if ( ! empty( $pathfinder_sc ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_output front_page_section_contacts_output front_page_block_<?php echo ! empty( $pathfinder_sc ) ? 'filled' : 'empty'; ?>">
					<?php
					pathfinder_show_layout( do_shortcode( $pathfinder_sc ) );
					?>
				</div>
				<?php
			}

			if ( 'columns' == $pathfinder_layout && ( ! empty( $pathfinder_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>

		</div>
	</div>
</div>
