<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package PATHFINDER
 * @since PATHFINDER 1.0
 */

							do_action( 'pathfinder_action_page_content_end_text' );
							
							// Widgets area below the content
							pathfinder_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'pathfinder_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'pathfinder_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'pathfinder_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'pathfinder_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$pathfinder_body_style = pathfinder_get_theme_option( 'body_style' );
					$pathfinder_widgets_name = pathfinder_get_theme_option( 'widgets_below_page' );
					$pathfinder_show_widgets = ! pathfinder_is_off( $pathfinder_widgets_name ) && is_active_sidebar( $pathfinder_widgets_name );
					$pathfinder_show_related = pathfinder_is_single() && pathfinder_get_theme_option( 'related_position' ) == 'below_page';
					if ( $pathfinder_show_widgets || $pathfinder_show_related ) {
						if ( 'fullscreen' != $pathfinder_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $pathfinder_show_related ) {
							do_action( 'pathfinder_action_related_posts' );
						}

						// Widgets area below page content
						if ( $pathfinder_show_widgets ) {
							pathfinder_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $pathfinder_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'pathfinder_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'pathfinder_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! pathfinder_is_singular( 'post' ) && ! pathfinder_is_singular( 'attachment' ) ) || ! in_array ( pathfinder_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="pathfinder_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'pathfinder_action_before_footer' );

				// Footer
				$pathfinder_footer_type = pathfinder_get_theme_option( 'footer_type' );
				if ( 'custom' == $pathfinder_footer_type && ! pathfinder_is_layouts_available() ) {
					$pathfinder_footer_type = 'default';
				}
				get_template_part( apply_filters( 'pathfinder_filter_get_template_part', "templates/footer-" . sanitize_file_name( $pathfinder_footer_type ) ) );

				do_action( 'pathfinder_action_after_footer' );

			}
			?>

			<?php do_action( 'pathfinder_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'pathfinder_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'pathfinder_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>